<?php
	class Recaptcha
	{
		protected $site_key;
        protected $secret_key;
        protected $verification_url;

		# The constructor
		public function __construct()
		{
			$this->site_key  = RECAPTCHA_SITE_KEY;
            $this->secret_key  = RECAPTCHA_SECRET_KEY;
            $this->verification_url = 'https://www.google.com/recaptcha/api/siteverify';
		}

		# List the properties
		public function buildRecaptchaHtml()
		{
            return "<div class='g-recaptcha' data-sitekey=".$this->site_key."></div>";
		}


		public function validateRecaptcha($response){
		    $url = $this->verification_url;
            $data = array(
                'secret' => $this->secret_key,
                'response' => $response
            );
            $options = array(
                'http' => array (
                    'method' => 'POST',
                    'content' => http_build_query($data)
                ),
                'ssl' => array(
                    'verify_peer' => false,
                    'verify_peer_name' => false
                )
            );
            $context  = stream_context_create($options);
            $verify = file_get_contents($url, false, $context);
            $captcha_success=json_decode($verify);
            return $captcha_success->success;
        }
	}
?>